#include "FitCANBusFDSample.h"
#include <queue>
#include <thread>
#include <future>
#include <mutex>
#include <vector>

using namespace std;

#define CAN_IER_SETTING 0
#define CANBUS_SINGLE_FILTER_MODE 1

class CanRecord{
public:
	FITAPI::CFitekCanBusFdControl::CanFdFrameInfor msg;
	int count;
	CanRecord(FITAPI::CFitekCanBusFdControl::CanFdFrameInfor* message);
};

CanRecord::CanRecord(FITAPI::CFitekCanBusFdControl::CanFdFrameInfor* msg) {
	memcpy(&this->msg, msg, sizeof(FITAPI::CFitekCanBusFdControl::CanFdFrameInfor));
	count = 1;
}

vector<CanRecord*> TxRecords;
vector<CanRecord*> RxRecords;

void CheckRecords(vector<CanRecord*> &records, FITAPI::CFitekCanBusFdControl::CanFdFrameInfor* message) {
	for (size_t i = 0; i < records.size(); i++) {
		if (memcmp(records[i], message, sizeof(FITAPI::CFitekCanBusFdControl::CanFdFrameInfor)) == 0) {
			records[i]->count++;
			return;
		}
	}
	records.push_back(new CanRecord(message));
}

void appendMessage(char* str, size_t size, FITAPI::CFitekCanBusFdControl::CanFdFrameInfor* msg) {
	if (msg->type == FITAPI::CFitekCanBusFdControl::CanFdFrameFormat::CP_11Bit)
		_snprintf_s(str, size, _TRUNCATE, "%s%d(%03Xh)[%d]", str, msg->id, msg->id, msg->data_len);
	else
		_snprintf_s(str, size, _TRUNCATE, "%s%d(%08Xh)[%d]", str, msg->id, msg->id, msg->data_len);
	for (int i = 0; i < msg->data_len; i++) {
		_snprintf_s(str, size, _TRUNCATE, "%s %02X", str, msg->data[i]);
	}
	printf_s("\n");
}

FitCANBusFd::FitCANBusFd(char* sComPortNumber) {
	printf_s("FitCANBus CAN bus = %s\n", sComPortNumber);
	strcpy_s(asComPortNumber, sComPortNumber);
	hCan = new FITAPI::CFitekCanBusFdControl();
}

FitCANBusFd::~FitCANBusFd() {
	long ret;
	unsigned long lasterror = 0;

	ret = hCan->FintekCanbusFd_GetErrorCode(asComPortNumber, &lasterror);
	if (ret < 0) {
		printf_s("Unable to get error code ret= %x\n", ret);
	}

	ret = hCan->FintekCanbusFd_Close(asComPortNumber);
	printf_s("Uninitialize CAN bus = %x error = %x\n", ret, lasterror);
	Sleep(100);

	// delete records
	for (size_t i = 0; i < RxRecords.size(); i++)
		delete RxRecords[i];
	RxRecords.clear();
	for (size_t i = 0; i < TxRecords.size(); i++)
		delete TxRecords[i];
	TxRecords.clear();
}

long FitCANBusFd::init(DWORD baudrate, FITAPI::CFitekCanBusFdControl::CanFdInitial* fdmsg_initial) {
	long ret;
	FILE* fd = NULL;	
	
	printf_s("FintekCanbus_Open\n");	
	
	// Initial CAN bus. (It is matter)
	ret = hCan->FintekCanbusFd_Open(asComPortNumber, fdmsg_initial);
	if (ret < 0) {
		printf_s("Failed to initialise CAN bus IO controller %x\n", ret);
		return ret;
	}

	// Set CAN bus baudrate. (It is matter)
	ret = hCan->FintekCanbusFd_SetBaudRate(asComPortNumber, baudrate);
	if (ret < 0) {
		printf_s("Unable to set CAN bus baud rate %x\n", ret);
		return ret;
	}
	// Confirm the CAN bus baudRate.
	DWORD baudRate;
	ret = hCan->FintekCanbusFd_GetBaudRate(asComPortNumber, &baudRate);
	if (ret < 0) {
		printf_s("Unable to get CAN bus baud rate %x\n", ret);
		return ret;
	}
	printf_s("CAN Bus Baud Rate: %d\n", baudRate);

#if CAN_IER_SETTING
	unsigned char ucIer = 0xEF;
	// Set CAN bus IER.
	ret = hCan->FintekCanbusFd_SetIer(asComPortNumber, ucIer);
	if (ret < 0) {
		printf_s("Unable to set CAN bus IER %x\n", ret);
		return ret;
	}
	// Confirm the CAN bus IER.	
	ret = hCan->FintekCanbusFd_GetIer(asComPortNumber, &ucIer);
	if (ret < 0) {
		printf_s("Unable to get CAN bus IER %x\n", ret);
		return ret;
	}
	printf_s("CAN Bus IER: 0x%X\n", ucIer);
#endif

	return ret;
}

static DWORD64 rxCnt = 0;
static DWORD64 errorCnt1 = 0;
static DWORD64 errorCnt2 = 0;

void CALLBACK callback(long error, FITAPI::CFitekCanBusFdControl::CanFdFrameInfor* message)
{
	int i;
	rxCnt++;
	if (error) {
		printf_s("Read error: %Xh\n", error);
		if ((error == 0x80050FFF) || (error == 0x8005FFFF)) {
			errorCnt2++;
		}
		else {
			errorCnt1++;
		}
	}
	else {
		char tmp[MAX_PATH];
		CheckRecords(RxRecords, message);
		if (message->rtr == 1)
		{
			_snprintf_s(tmp, sizeof(tmp), "[RX]RTR[%d]", message->rtr);
		}
		else
		{
			if (message->type == FITAPI::CFitekCanBusFdControl::CanFdFrameFormat::CP_11Bit)
				_snprintf_s(tmp, sizeof(tmp), "[RX]%03Xh[%d]", message->id, message->data_len);
			else
				_snprintf_s(tmp, sizeof(tmp), "[RX]%08Xh[%d]", message->id, message->data_len);

			for (i = 0; i < message->data_len; i++) {
				_snprintf_s(tmp, sizeof(tmp), "%s %02X", tmp, message->data[i]);
			}
		}
		printf_s(tmp);
		printf_s("\n");
	}
}

long FitCANBusFd::startReading(int num, DWORD acr, DWORD amr)
{
	long ret;
	
	// set CAN filter (acr/amr)
	ret = hCan->FintekCanbusFd_SetAcrAmrFilter(asComPortNumber, CANBUS_SINGLE_FILTER_MODE, acr, amr);
	if (ret < 0) {
		printf_s("Unable to set CAN filter (acr/arm) %x\n", ret);
	}

	// set CAN read callback
	ret = hCan->FintekCanbusFd_Receive(asComPortNumber, callback);
	if (ret < 0) {
		printf_s("Unable to set CAN message read callback %x\n", ret);
	}
	return ret;
}


long FitCANBusFd::writeMessage(FITAPI::CFitekCanBusFdControl::CanFdFrameInfor* msg)
{
	long ret;
#ifdef DEBUG_MSG
	char tmp[MAX_PATH];
	CheckRecords(TxRecords, msg);
	strcpy_s(tmp, "[TX]");
	appendMessage(tmp, sizeof(tmp), msg);
	printf(tmp);
#endif
	ret = hCan->FintekCanbusFd_Send(asComPortNumber, msg);
	if (ret < 0) {
		printf_s("Unable to write %Xh message %x\n", msg->id, msg->data_len);
	}
	return ret;
}